/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.emi.recipes;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.compat.emi.CreateSlotWidget;
import com.simibubi.create.compat.emi.EmiSequencedAssemblySubCategory;
import com.simibubi.create.compat.emi.recipes.SequencedAssemblyEmiRecipe;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.Pair;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.TextureWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_638;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public abstract class CreateEmiRecipe<T extends class_1860<?>>
implements EmiRecipe {
    protected final EmiRecipeCategory category;
    protected final T recipe;
    protected class_2960 id;
    protected List<EmiIngredient> input;
    protected List<EmiStack> output;
    protected int width;
    protected int height;

    public CreateEmiRecipe(EmiRecipeCategory category, T recipe, int width, int height) {
        this.category = category;
        this.recipe = recipe;
        this.id = recipe.method_8114();
        this.width = width;
        this.height = height;
        if (recipe instanceof BasinRecipe) {
            BasinRecipe basin = (BasinRecipe)recipe;
            ImmutableList.Builder input = ImmutableList.builder();
            ImmutableList.Builder output = ImmutableList.builder();
            for (Pair<class_1856, MutableInt> pair : ItemHelper.condenseIngredients((class_2371<class_1856>)recipe.method_8117())) {
                input.add((Object)EmiIngredient.of((class_1856)pair.getFirst(), (long)pair.getSecond().getValue().intValue()));
            }
            for (FluidIngredient ingredient : basin.getFluidIngredients()) {
                List<FluidStack> fluids = ingredient.getMatchingFluidStacks();
                if (fluids.isEmpty()) continue;
                input.add((Object)CreateEmiRecipe.fluidStack(fluids.get(0)));
            }
            for (class_1799 stack : basin.getRollableResultsAsItemStacks()) {
                output.add((Object)EmiStack.of((class_1799)stack));
            }
            for (class_1799 stack : basin.getFluidResults()) {
                output.add((Object)CreateEmiRecipe.fluidStack((FluidStack)stack));
            }
            this.input = input.build();
            this.output = output.build();
        } else if (recipe instanceof SequencedAssemblyRecipe) {
            SequencedAssemblyRecipe sequenced = (SequencedAssemblyRecipe)recipe;
            this.output = List.of(CreateEmiRecipe.getResultEmi(recipe).setChance(sequenced.getOutputChance()));
            int loops = sequenced.getLoops();
            ImmutableList.Builder input = ImmutableList.builder();
            input.add((Object)EmiIngredient.of((class_1856)sequenced.getIngredient()));
            for (SequencedRecipe<?> sequence : sequenced.getSequence()) {
                EmiStack stack;
                EmiSequencedAssemblySubCategory subCategory = SequencedAssemblyEmiRecipe.getSubCategory(sequence);
                EmiIngredient ingredient = subCategory.getAppliedIngredient(sequence);
                if (ingredient == null) continue;
                input.add((Object)ingredient);
                if (ingredient instanceof EmiStack && (stack = (EmiStack)ingredient).getRemainder() == stack) continue;
                ingredient.setAmount(ingredient.getAmount() * (long)loops);
            }
            this.input = input.build();
        } else {
            this.input = recipe.method_8117().stream().map(EmiIngredient::of).toList();
            if (recipe instanceof ProcessingRecipe) {
                ProcessingRecipe processing = (ProcessingRecipe)recipe;
                ImmutableList.Builder builder = ImmutableList.builder();
                for (ProcessingOutput output : processing.getRollableResults()) {
                    builder.add((Object)EmiStack.of((class_1799)output.getStack()).setChance(output.getChance()));
                }
                this.output = builder.build();
            } else {
                this.output = List.of(CreateEmiRecipe.getResultEmi(recipe));
            }
        }
    }

    public CreateEmiRecipe(EmiRecipeCategory category, T recipe, int width, int height, Consumer<CreateEmiRecipe<T>> setup) {
        this.category = category;
        this.recipe = recipe;
        this.id = recipe.method_8114();
        this.width = width;
        this.height = height;
        setup.accept(this);
    }

    public EmiRecipeCategory getCategory() {
        return this.category;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return this.width;
    }

    public int getDisplayHeight() {
        return this.height;
    }

    public static SlotWidget addSlot(WidgetHolder widgets, EmiIngredient stack, int x, int y) {
        AllGuiTextures texture = stack.getChance() == 1.0f ? AllGuiTextures.JEI_SLOT : AllGuiTextures.JEI_CHANCE_SLOT;
        return CreateEmiRecipe.addSlot(widgets, stack, x, y, texture);
    }

    public static SlotWidget addSlot(WidgetHolder widgets, EmiIngredient stack, int x, int y, AllGuiTextures texture) {
        return ((CreateSlotWidget)widgets.add((Widget)new CreateSlotWidget(stack, x, y))).backgroundTexture(texture.location, texture.startX, texture.startY);
    }

    public static EmiStack fluidStack(FluidStack stack) {
        return EmiStack.of((class_3611)stack.getFluid(), (class_2487)stack.getTag(), (long)stack.getAmount());
    }

    public static TextureWidget addTexture(WidgetHolder widgets, AllGuiTextures texture, int x, int y) {
        return widgets.addTexture(texture.location, x, y, texture.width, texture.height, texture.startX, texture.startY);
    }

    public static <T, U> U firstOrElse(List<T> list, U empty, Function<T, U> function) {
        return list.isEmpty() ? empty : function.apply(list.get(0));
    }

    public static EmiIngredient firstIngredientOrEmpty(List<class_1856> ingredients) {
        return CreateEmiRecipe.firstOrElse(ingredients, EmiStack.EMPTY, EmiIngredient::of);
    }

    public static EmiStack firstFluidOrEmpty(List<FluidStack> fluids) {
        return CreateEmiRecipe.firstOrElse(fluids, EmiStack.EMPTY, CreateEmiRecipe::fluidStack);
    }

    public static EmiStack firstResultOrEmpty(List<ProcessingOutput> outputs) {
        return CreateEmiRecipe.firstOrElse(outputs, EmiStack.EMPTY, output -> EmiStack.of((class_1799)output.getStack()));
    }

    public static class_1799 getResultItem(class_1860<?> recipe) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return class_1799.field_8037;
        }
        return recipe.method_8110(level.method_30349());
    }

    public static EmiStack getResultEmi(class_1860<?> recipe) {
        return EmiStack.of((class_1799)CreateEmiRecipe.getResultItem(recipe));
    }
}

